

<?php $__env->startSection('title', 'Video Consultation'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-4 sm:mb-6">Video Consultation</h1>

    <div class="bg-white rounded-lg shadow p-4 sm:p-6 mb-4 sm:mb-6">
        <h2 class="text-lg sm:text-xl font-bold mb-3 sm:mb-4">Appointment Details</h2>
        <p><strong>Patient:</strong> <?php echo e($appointment->patient->full_name); ?></p>
        <p><strong>Doctor:</strong> <?php echo e($appointment->doctor ? $appointment->doctor->full_name : 'Not Assigned'); ?></p>
        <p><strong>Room ID:</strong> <?php echo e($appointment->video_call_room_id); ?></p>
        <?php if($appointment->google_meet_link): ?>
            <p><strong>Google Meet Link:</strong> <a href="<?php echo e($appointment->google_meet_link); ?>" target="_blank" class="text-blue-600 hover:underline"><?php echo e($appointment->google_meet_link); ?></a></p>
        <?php endif; ?>
    </div>

    <div class="bg-white rounded-lg shadow p-4 sm:p-6">
        <div class="mb-3 sm:mb-4">
            <label class="block text-gray-700 text-sm font-bold mb-2">Video Call Provider</label>
            <select id="videoProvider" class="w-full px-3 py-2 border rounded text-sm sm:text-base">
                <option value="google" <?php echo e($appointment->google_meet_link ? 'selected' : ''); ?>>Google Meet</option>
                <option value="jitsi" <?php echo e(!$appointment->google_meet_link ? 'selected' : ''); ?>>Jitsi Meet</option>
            </select>
        </div>
        
        <div id="jitsi-container" style="width: 100%; height: 400px; min-height: 400px; display: none;" class="sm:h-[500px] lg:h-[600px]"></div>
        <div id="google-meet-container" class="<?php echo e($appointment->google_meet_link ? '' : 'hidden'); ?>">
            <iframe 
                id="googleMeetFrame"
                allow="camera; microphone; fullscreen; speaker; display-capture"
                style="width: 100%; height: 400px; min-height: 400px; border: none;" class="sm:h-[500px] lg:h-[600px]">
            </iframe>
        </div>
    </div>
</div>

<div id="jitsi-container" style="width: 100%; height: 600px;"></div>
<div id="google-meet-container" class="hidden">
    <iframe 
        id="googleMeetFrame"
        allow="camera; microphone; fullscreen; speaker; display-capture"
        style="width: 100%; height: 600px; border: none;">
    </iframe>
</div>

<script src="https://8x8.vc/external_api.js"></script>
<script>
    let jitsiApi = null;
    const roomName = '<?php echo e($appointment->video_call_room_id); ?>';
    const googleMeetLink = <?php echo json_encode($appointment->google_meet_link, 15, 512) ?>;
    
    // Initialize Jitsi
    function initJitsi() {
        const domain = 'meet.jit.si';
        const options = {
            roomName: roomName,
            width: '100%',
            height: window.innerWidth < 640 ? 400 : (window.innerWidth < 1024 ? 500 : 600),
            parentNode: document.querySelector('#jitsi-container'),
            configOverwrite: {
                startWithAudioMuted: false,
                startWithVideoMuted: false,
            },
            interfaceConfigOverwrite: {
                TOOLBAR_BUTTONS: [
                    'microphone', 'camera', 'closedcaptions', 'desktop', 'fullscreen',
                    'fodeviceselection', 'hangup', 'profile', 'chat', 'recording',
                    'livestreaming', 'settings', 'raisehand', 'videoquality', 'filmstrip',
                    'invite', 'feedback', 'stats', 'shortcuts', 'tileview', 'videobackgroundblur',
                    'download', 'help', 'mute-everyone', 'security'
                ],
            }
        };

        jitsiApi = new JitsiMeetExternalAPI(domain, options);

        jitsiApi.addEventListener('videoConferenceJoined', () => {
            console.log('Joined Jitsi video conference');
        });

        jitsiApi.addEventListener('videoConferenceLeft', () => {
            console.log('Left Jitsi video conference');
            window.location.href = '<?php echo e(route("pharmacist.appointments")); ?>';
        });
    }

    function initGoogleMeet() {
        const meetUrl = googleMeetLink || `https://meet.google.com/${roomName}`;
        document.getElementById('googleMeetFrame').src = meetUrl;
    }

    // Initialize with Google Meet if link exists, otherwise Jitsi
    if (googleMeetLink) {
        document.getElementById('videoProvider').value = 'google';
        initGoogleMeet();
        document.getElementById('jitsi-container').style.display = 'none';
        document.getElementById('google-meet-container').classList.remove('hidden');
    } else {
        initJitsi();
        document.getElementById('jitsi-container').style.display = 'block';
    }

    // Handle provider switch
    document.getElementById('videoProvider').addEventListener('change', function() {
        if (this.value === 'jitsi') {
            document.getElementById('jitsi-container').style.display = 'block';
            document.getElementById('google-meet-container').classList.add('hidden');
            if (!jitsiApi) {
                initJitsi();
            }
        } else {
            document.getElementById('jitsi-container').style.display = 'none';
            document.getElementById('google-meet-container').classList.remove('hidden');
            if (jitsiApi) {
                jitsiApi.dispose();
                jitsiApi = null;
            }
            initGoogleMeet();
        }
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/pharmacist/video-call.blade.php ENDPATH**/ ?>